(function(){
  function ready(fn){
    if(document.readyState !== 'loading'){ fn(); }
    else { document.addEventListener('DOMContentLoaded', fn); }
  }

  function getLinkUrl(a){
    if(!a) return '';
    return a.getAttribute('data-full') || a.getAttribute('href') || '';
  }

  ready(function(){
    var strips = Array.prototype.slice.call(document.querySelectorAll('.mmg-filmstrip'));
    if(!strips.length) return;

    var overlay = document.querySelector('.mmg-overlay');
    if(!overlay){
      overlay = document.createElement('div');
      overlay.className = 'mmg-overlay';
      overlay.setAttribute('role', 'dialog');
      overlay.setAttribute('aria-modal', 'true');
      overlay.innerHTML = ''+
        '<button class="mmg-close" aria-label="Stäng"><span class="mmg-sr">Stäng</span>×</button>'+
        '<button class="mmg-prev" aria-label="Föregående"><span class="mmg-sr">Föregående</span>‹</button>'+
        '<img alt="" />'+
        '<button class="mmg-next" aria-label="Nästa"><span class="mmg-sr">Nästa</span>›</button>'+
        '<span class="mmg-sr" aria-live="polite"></span>';
      document.body.appendChild(overlay);
    }

    var imgEl = overlay.querySelector('img');
    var obClose = overlay.querySelector('.mmg-close');
    var obPrev = overlay.querySelector('.mmg-prev');
    var obNext = overlay.querySelector('.mmg-next');

    var lbList = [];
    var lbIndex = -1;
    var lastFocused = null;

    function lbLoad(i){
      if(i < 0 || i >= lbList.length) return;
      var a = lbList[i];
      var url = getLinkUrl(a);
      if(!url) return;

      var thumb = a.querySelector('img');
      imgEl.setAttribute('src', url);
      imgEl.setAttribute('alt', thumb ? (thumb.getAttribute('alt') || '') : '');

      [i - 1, i + 1].forEach(function(k){
        if(lbList[k]){
          var pre = new Image();
          pre.src = getLinkUrl(lbList[k]);
        }
      });
    }

    function lbOpen(list, index){
      lbList = list;
      lbIndex = index;
      if(lbIndex < 0) lbIndex = 0;
      lastFocused = document.activeElement;
      document.body.classList.add('mmg-no-scroll');
      lbLoad(lbIndex);
      overlay.classList.add('is-open');
      obClose.focus();
    }

    function lbClose(){
      overlay.classList.remove('is-open');
      document.body.classList.remove('mmg-no-scroll');
      if(lastFocused && typeof lastFocused.focus === 'function') lastFocused.focus();
    }

    function lbPrev(){
      if(lbIndex > 0){ lbIndex--; lbLoad(lbIndex); }
    }

    function lbNext(){
      if(lbIndex < lbList.length - 1){ lbIndex++; lbLoad(lbIndex); }
    }

    function onKey(e){
      if(!overlay.classList.contains('is-open')) return;
      if(e.key === 'Escape') lbClose();
      else if(e.key === 'ArrowLeft') lbPrev();
      else if(e.key === 'ArrowRight') lbNext();
    }

    obClose.addEventListener('click', lbClose);
    obPrev.addEventListener('click', lbPrev);
    obNext.addEventListener('click', lbNext);
    overlay.addEventListener('click', function(e){ if(e.target === overlay) lbClose(); });
    window.addEventListener('keydown', onKey);

    strips.forEach(function(strip){
      var track = strip.querySelector('.mmg-track');
      if(!track) return;

      var prev = strip.querySelector('.mmg-nav.mmg-prev');
      var next = strip.querySelector('.mmg-nav.mmg-next');
      var links = Array.prototype.slice.call(track.querySelectorAll('.mmg-link'));
      if(!links.length) return;

      function layout(){
        var gap = parseFloat(getComputedStyle(track).columnGap || getComputedStyle(track).gap || '8') || 8;
        var min = parseFloat(getComputedStyle(strip).getPropertyValue('--mmg-item-min')) || 180;
        var per = Math.max(1, Math.floor((strip.clientWidth + gap) / (min + gap)));
        var width = Math.floor((strip.clientWidth - gap * (per - 1)) / per);
        links.forEach(function(a){ a.style.flex = '0 0 ' + width + 'px'; });
      }

      layout();
      window.addEventListener('resize', layout);

      function step(dir){
        var one = links[0];
        var width = one ? one.getBoundingClientRect().width : 200;
        var gap = parseFloat(getComputedStyle(track).columnGap || getComputedStyle(track).gap || '8') || 8;
        var per = Math.max(1, Math.floor((strip.clientWidth + gap) / (width + gap)));
        var delta = (width + gap) * per;
        var max = Math.max(0, track.scrollWidth - track.clientWidth);
        var target = track.scrollLeft + (dir < 0 ? -delta : delta);
        target = Math.max(0, Math.min(max, target));
        track.scrollTo({ left: target, behavior: 'smooth' });
      }

      if(prev){ prev.addEventListener('click', function(){ step(-1); }); }
      if(next){ next.addEventListener('click', function(){ step(1); }); }
    });

    // Capture-phase delegate: robust against theme/page-builder handlers.
    document.addEventListener('click', function(e){
      var a = e.target.closest('.mmg-filmstrip .mmg-link');
      if(!a) return;
      if(e.metaKey || e.ctrlKey || e.shiftKey || e.altKey) return;

      var strip = a.closest('.mmg-filmstrip');
      if(!strip) return;

      var list = Array.prototype.slice.call(strip.querySelectorAll('.mmg-link'));
      if(!list.length) return;

      e.preventDefault();
      e.stopPropagation();

      var idx = list.indexOf(a);
      lbOpen(list, idx);
    }, true);
  });
})();
