(function($){
  var frame;

  function refreshHiddenInput($list){
    var ids = [];
    $list.find('.mmg-item').each(function(){ ids.push( $(this).data('id') ); });
    $('#mmg-image-ids').val(ids.join(','));
  }

  $(document).on('click', '#mmg-add', function(e){
    e.preventDefault();
    if (frame) { frame.open(); return; }

    frame = wp.media({
      title: 'Välj bilder',
      button: { text: 'Lägg till' },
      multiple: true,
      library: { type: 'image' }
    });

    frame.on('select', function(){
      var selection = frame.state().get('selection');
      var $list = $('#mmg-list');
      selection.each(function(attachment){
        attachment = attachment.toJSON();
        var id = attachment.id;
        var thumb = (attachment.sizes && attachment.sizes.thumbnail) ? attachment.sizes.thumbnail.url : attachment.url;
        var alt = attachment.alt || '';
        if ($list.find('.mmg-item[data-id="'+id+'"]').length) return;
        var html = '<div class="mmg-item" data-id="'+id+'">'+
                    '<img src="'+thumb+'" alt="'+_.escape(alt)+'"/>'+
                    '<button type="button" class="button-link mmg-remove" aria-label="Ta bort">&times;</button>'+
                   '</div>';
        $list.append(html);
      });
      refreshHiddenInput($('#mmg-list'));
    });

    frame.open();
  });

  $(document).on('click', '.mmg-remove', function(){
    var $item = $(this).closest('.mmg-item');
    $item.remove();
    refreshHiddenInput($('#mmg-list'));
  });

  $(function(){
    $('#mmg-list').sortable({
      items: '.mmg-item',
      update: function(){ refreshHiddenInput($('#mmg-list')); }
    });
  });

})(jQuery);
